//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 16:31:44 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: delta_fisette_c
//
//	==> Number of joints: 23
//
//	==> Function: F6 - Sensors Kinematics
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"
#include "mbs_sensor.h"

void mbs_gensensor(MbsSensor *sens,
MbsData *s, int isens)
{
#include "mbs_gensensor_delta_fisette_c.h"

double *q, *qd, *qdd;
double **dpt;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
 
// Trigonometric functions

S4 = sin(q[4]);
C4 = cos(q[4]);
S5 = sin(q[5]);
C5 = cos(q[5]);
S6 = sin(q[6]);
C6 = cos(q[6]);
S7 = sin(q[7]);
C7 = cos(q[7]);
S8 = sin(q[8]);
C8 = cos(q[8]);
S9 = sin(q[9]);
C9 = cos(q[9]);
S10 = sin(q[10]);
C10 = cos(q[10]);
S11 = sin(q[11]);
C11 = cos(q[11]);
S12 = sin(q[12]);
C12 = cos(q[12]);
S13 = sin(q[13]);
C13 = cos(q[13]);
S14 = sin(q[14]);
C14 = cos(q[14]);
S15 = sin(q[15]);
C15 = cos(q[15]);
S16 = sin(q[16]);
C16 = cos(q[16]);
S17 = sin(q[17]);
C17 = cos(q[17]);
S18 = sin(q[18]);
C18 = cos(q[18]);
S19 = sin(q[19]);
C19 = cos(q[19]);
S20 = sin(q[20]);
C20 = cos(q[20]);
S21 = sin(q[21]);
C21 = cos(q[21]);
S22 = sin(q[22]);
C22 = cos(q[22]);
S23 = sin(q[23]);
C23 = cos(q[23]);
 
// Augmented Joint Position Vectors

 
// Sensor Kinematics


switch(isens)
{
case 1:

sens->P[1] = q[1];
sens->P[2] = 0;
sens->P[3] = 0;
sens->R[1][1] = (1.0);
sens->R[2][2] = (1.0);
sens->R[3][3] = (1.0);
sens->V[1] = qd[1];
sens->V[2] = 0;
sens->V[3] = 0;
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = 0;
sens->A[3] = 0;
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 2:

sens->P[1] = q[1];
sens->P[2] = q[2];
sens->P[3] = 0;
sens->R[1][1] = (1.0);
sens->R[2][2] = (1.0);
sens->R[3][3] = (1.0);
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = 0;
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = 0;
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 3:

sens->P[1] = q[1];
sens->P[2] = q[2];
sens->P[3] = q[3];
sens->R[1][1] = (1.0);
sens->R[2][2] = (1.0);
sens->R[3][3] = (1.0);
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = qd[3];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->J[3][3] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = qdd[3];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 4:

POcp4_14 = q[1]+dpt[1][4];
sens->P[1] = POcp4_14;
sens->P[2] = q[2];
sens->P[3] = q[3];
sens->R[1][1] = C4;
sens->R[1][2] = S4;
sens->R[2][1] = -S4;
sens->R[2][2] = C4;
sens->R[3][3] = (1.0);
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = qd[3];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->J[3][3] = (1.0);
sens->J[6][4] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = qdd[3];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 5:

ROcp5_15 = C4*C5;
ROcp5_25 = S4*C5;
ROcp5_75 = C4*S5;
ROcp5_85 = S4*S5;
POcp5_14 = q[1]+dpt[1][4];
sens->P[1] = POcp5_14;
sens->P[2] = q[2];
sens->P[3] = q[3];
sens->R[1][1] = ROcp5_15;
sens->R[1][2] = ROcp5_25;
sens->R[1][3] = -S5;
sens->R[2][1] = -S4;
sens->R[2][2] = C4;
sens->R[3][1] = ROcp5_75;
sens->R[3][2] = ROcp5_85;
sens->R[3][3] = C5;
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = qd[3];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->J[3][3] = (1.0);
sens->J[4][5] = -S4;
sens->J[5][5] = C4;
sens->J[6][4] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = qdd[3];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 6:

POcp6_14 = q[1]+dpt[1][5];
POcp6_24 = q[2]+dpt[2][5];
sens->P[1] = POcp6_14;
sens->P[2] = POcp6_24;
sens->P[3] = q[3];
sens->R[1][1] = C6;
sens->R[1][2] = S6;
sens->R[2][1] = -S6;
sens->R[2][2] = C6;
sens->R[3][3] = (1.0);
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = qd[3];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->J[3][3] = (1.0);
sens->J[6][6] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = qdd[3];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 7:

ROcp7_17 = C6*C7;
ROcp7_27 = S6*C7;
ROcp7_77 = C6*S7;
ROcp7_87 = S6*S7;
POcp7_14 = q[1]+dpt[1][5];
POcp7_24 = q[2]+dpt[2][5];
sens->P[1] = POcp7_14;
sens->P[2] = POcp7_24;
sens->P[3] = q[3];
sens->R[1][1] = ROcp7_17;
sens->R[1][2] = ROcp7_27;
sens->R[1][3] = -S7;
sens->R[2][1] = -S6;
sens->R[2][2] = C6;
sens->R[3][1] = ROcp7_77;
sens->R[3][2] = ROcp7_87;
sens->R[3][3] = C7;
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = qd[3];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->J[3][3] = (1.0);
sens->J[4][7] = -S6;
sens->J[5][7] = C6;
sens->J[6][6] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = qdd[3];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 8:

POcp8_14 = q[1]+dpt[1][6];
POcp8_24 = q[2]+dpt[2][6];
sens->P[1] = POcp8_14;
sens->P[2] = POcp8_24;
sens->P[3] = q[3];
sens->R[1][1] = C8;
sens->R[1][2] = S8;
sens->R[2][1] = -S8;
sens->R[2][2] = C8;
sens->R[3][3] = (1.0);
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = qd[3];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->J[3][3] = (1.0);
sens->J[6][8] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = qdd[3];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 9:

ROcp9_19 = C8*C9;
ROcp9_29 = S8*C9;
ROcp9_79 = C8*S9;
ROcp9_89 = S8*S9;
POcp9_14 = q[1]+dpt[1][6];
POcp9_24 = q[2]+dpt[2][6];
sens->P[1] = POcp9_14;
sens->P[2] = POcp9_24;
sens->P[3] = q[3];
sens->R[1][1] = ROcp9_19;
sens->R[1][2] = ROcp9_29;
sens->R[1][3] = -S9;
sens->R[2][1] = -S8;
sens->R[2][2] = C8;
sens->R[3][1] = ROcp9_79;
sens->R[3][2] = ROcp9_89;
sens->R[3][3] = C9;
sens->V[1] = qd[1];
sens->V[2] = qd[2];
sens->V[3] = qd[3];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[1][1] = (1.0);
sens->J[2][2] = (1.0);
sens->J[3][3] = (1.0);
sens->J[4][9] = -S8;
sens->J[5][9] = C8;
sens->J[6][8] = (1.0);
sens->A[1] = qdd[1];
sens->A[2] = qdd[2];
sens->A[3] = qdd[3];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 10:

sens->P[1] = dpt[1][1];
sens->P[2] = 0;
sens->P[3] = 0;
sens->R[1][1] = C10;
sens->R[1][3] = -S10;
sens->R[2][2] = (1.0);
sens->R[3][1] = S10;
sens->R[3][3] = C10;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = 0;
sens->OM[1] = 0;
sens->OM[2] = qd[10];
sens->OM[3] = 0;
sens->J[5][10] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = 0;
sens->OMP[1] = 0;
sens->OMP[2] = qdd[10];
sens->OMP[3] = 0;

break;

case 11:

ROcp11_111 = C10*C11-S10*S11;
ROcp11_311 = -C10*S11-S10*C11;
ROcp11_711 = C10*S11+S10*C11;
ROcp11_911 = C10*C11-S10*S11;
RLcp11_12 = dpt[3][11]*S10;
RLcp11_32 = dpt[3][11]*C10;
POcp11_12 = RLcp11_12+dpt[1][1];
OMcp11_22 = qd[10]+qd[11];
ORcp11_12 = RLcp11_32*qd[10];
ORcp11_32 = -RLcp11_12*qd[10];
OPcp11_22 = qdd[10]+qdd[11];
ACcp11_12 = ORcp11_32*qd[10]+RLcp11_32*qdd[10];
ACcp11_32 = -ORcp11_12*qd[10]-RLcp11_12*qdd[10];
sens->P[1] = POcp11_12;
sens->P[2] = 0;
sens->P[3] = RLcp11_32;
sens->R[1][1] = ROcp11_111;
sens->R[1][3] = ROcp11_311;
sens->R[2][2] = (1.0);
sens->R[3][1] = ROcp11_711;
sens->R[3][3] = ROcp11_911;
sens->V[1] = ORcp11_12;
sens->V[2] = 0;
sens->V[3] = ORcp11_32;
sens->OM[1] = 0;
sens->OM[2] = OMcp11_22;
sens->OM[3] = 0;
sens->J[1][10] = RLcp11_32;
sens->J[3][10] = -RLcp11_12;
sens->J[5][10] = (1.0);
sens->J[5][11] = (1.0);
sens->A[1] = ACcp11_12;
sens->A[2] = 0;
sens->A[3] = ACcp11_32;
sens->OMP[1] = 0;
sens->OMP[2] = OPcp11_22;
sens->OMP[3] = 0;

break;

case 12:

ROcp12_111 = C10*C11-S10*S11;
ROcp12_311 = -C10*S11-S10*C11;
ROcp12_711 = C10*S11+S10*C11;
ROcp12_911 = C10*C11-S10*S11;
ROcp12_412 = ROcp12_711*S12;
ROcp12_612 = ROcp12_911*S12;
ROcp12_712 = ROcp12_711*C12;
ROcp12_912 = ROcp12_911*C12;
RLcp12_12 = dpt[3][11]*S10;
RLcp12_32 = dpt[3][11]*C10;
POcp12_12 = RLcp12_12+dpt[1][1];
OMcp12_22 = qd[10]+qd[11];
ORcp12_12 = RLcp12_32*qd[10];
ORcp12_32 = -RLcp12_12*qd[10];
OPcp12_22 = qdd[10]+qdd[11];
ACcp12_12 = ORcp12_32*qd[10]+RLcp12_32*qdd[10];
ACcp12_32 = -ORcp12_12*qd[10]-RLcp12_12*qdd[10];
OMcp12_13 = ROcp12_111*qd[12];
OMcp12_33 = ROcp12_311*qd[12];
OPcp12_13 = OMcp12_22*ROcp12_311*qd[12]+ROcp12_111*qdd[12];
OPcp12_33 = -OMcp12_22*ROcp12_111*qd[12]+ROcp12_311*qdd[12];
sens->P[1] = POcp12_12;
sens->P[2] = dpt[2][12];
sens->P[3] = RLcp12_32;
sens->R[1][1] = ROcp12_111;
sens->R[1][3] = ROcp12_311;
sens->R[2][1] = ROcp12_412;
sens->R[2][2] = C12;
sens->R[2][3] = ROcp12_612;
sens->R[3][1] = ROcp12_712;
sens->R[3][2] = -S12;
sens->R[3][3] = ROcp12_912;
sens->V[1] = ORcp12_12;
sens->V[2] = 0;
sens->V[3] = ORcp12_32;
sens->OM[1] = OMcp12_13;
sens->OM[2] = OMcp12_22;
sens->OM[3] = OMcp12_33;
sens->J[1][10] = RLcp12_32;
sens->J[3][10] = -RLcp12_12;
sens->J[4][12] = ROcp12_111;
sens->J[5][10] = (1.0);
sens->J[5][11] = (1.0);
sens->J[6][12] = ROcp12_311;
sens->A[1] = ACcp12_12;
sens->A[2] = 0;
sens->A[3] = ACcp12_32;
sens->OMP[1] = OPcp12_13;
sens->OMP[2] = OPcp12_22;
sens->OMP[3] = OPcp12_33;

break;

case 13:

ROcp13_111 = C10*C11-S10*S11;
ROcp13_311 = -C10*S11-S10*C11;
ROcp13_711 = C10*S11+S10*C11;
ROcp13_911 = C10*C11-S10*S11;
ROcp13_413 = ROcp13_711*S13;
ROcp13_613 = ROcp13_911*S13;
ROcp13_713 = ROcp13_711*C13;
ROcp13_913 = ROcp13_911*C13;
RLcp13_12 = dpt[3][11]*S10;
RLcp13_32 = dpt[3][11]*C10;
POcp13_12 = RLcp13_12+dpt[1][1];
OMcp13_22 = qd[10]+qd[11];
ORcp13_12 = RLcp13_32*qd[10];
ORcp13_32 = -RLcp13_12*qd[10];
OPcp13_22 = qdd[10]+qdd[11];
ACcp13_12 = ORcp13_32*qd[10]+RLcp13_32*qdd[10];
ACcp13_32 = -ORcp13_12*qd[10]-RLcp13_12*qdd[10];
OMcp13_13 = ROcp13_111*qd[13];
OMcp13_33 = ROcp13_311*qd[13];
OPcp13_13 = OMcp13_22*ROcp13_311*qd[13]+ROcp13_111*qdd[13];
OPcp13_33 = -OMcp13_22*ROcp13_111*qd[13]+ROcp13_311*qdd[13];
sens->P[1] = POcp13_12;
sens->P[2] = dpt[2][13];
sens->P[3] = RLcp13_32;
sens->R[1][1] = ROcp13_111;
sens->R[1][3] = ROcp13_311;
sens->R[2][1] = ROcp13_413;
sens->R[2][2] = C13;
sens->R[2][3] = ROcp13_613;
sens->R[3][1] = ROcp13_713;
sens->R[3][2] = -S13;
sens->R[3][3] = ROcp13_913;
sens->V[1] = ORcp13_12;
sens->V[2] = 0;
sens->V[3] = ORcp13_32;
sens->OM[1] = OMcp13_13;
sens->OM[2] = OMcp13_22;
sens->OM[3] = OMcp13_33;
sens->J[1][10] = RLcp13_32;
sens->J[3][10] = -RLcp13_12;
sens->J[4][13] = ROcp13_111;
sens->J[5][10] = (1.0);
sens->J[5][11] = (1.0);
sens->J[6][13] = ROcp13_311;
sens->A[1] = ACcp13_12;
sens->A[2] = 0;
sens->A[3] = ACcp13_32;
sens->OMP[1] = OPcp13_13;
sens->OMP[2] = OPcp13_22;
sens->OMP[3] = OPcp13_33;

break;

case 14:

sens->P[1] = dpt[1][2];
sens->P[2] = dpt[2][2];
sens->P[3] = 0;
sens->R[1][1] = C14;
sens->R[1][2] = S14;
sens->R[2][1] = -S14;
sens->R[2][2] = C14;
sens->R[3][3] = (1.0);
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = 0;
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[6][14] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = 0;
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 15:

ROcp15_115 = C14*C15;
ROcp15_215 = S14*C15;
ROcp15_715 = C14*S15;
ROcp15_815 = S14*S15;
OMcp15_12 = -qd[15]*S14;
OMcp15_22 = qd[15]*C14;
OPcp15_12 = -qdd[15]*S14;
OPcp15_22 = qdd[15]*C14;
sens->P[1] = dpt[1][2];
sens->P[2] = dpt[2][2];
sens->P[3] = 0;
sens->R[1][1] = ROcp15_115;
sens->R[1][2] = ROcp15_215;
sens->R[1][3] = -S15;
sens->R[2][1] = -S14;
sens->R[2][2] = C14;
sens->R[3][1] = ROcp15_715;
sens->R[3][2] = ROcp15_815;
sens->R[3][3] = C15;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = 0;
sens->OM[1] = OMcp15_12;
sens->OM[2] = OMcp15_22;
sens->OM[3] = 0;
sens->J[4][15] = -S14;
sens->J[5][15] = C14;
sens->J[6][14] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = 0;
sens->OMP[1] = OPcp15_12;
sens->OMP[2] = OPcp15_22;
sens->OMP[3] = 0;

break;

case 16:

ROcp16_115 = C14*C15;
ROcp16_215 = S14*C15;
ROcp16_715 = C14*S15;
ROcp16_815 = S14*S15;
ROcp16_116 = ROcp16_115*C16-ROcp16_715*S16;
ROcp16_216 = ROcp16_215*C16-ROcp16_815*S16;
ROcp16_316 = -C15*S16-S15*C16;
ROcp16_716 = ROcp16_115*S16+ROcp16_715*C16;
ROcp16_816 = ROcp16_215*S16+ROcp16_815*C16;
ROcp16_916 = C15*C16-S15*S16;
OMcp16_12 = -qd[15]*S14;
OMcp16_22 = qd[15]*C14;
OPcp16_12 = -qdd[15]*S14;
OPcp16_22 = qdd[15]*C14;
RLcp16_13 = ROcp16_715*dpt[3][15];
RLcp16_23 = ROcp16_815*dpt[3][15];
RLcp16_33 = dpt[3][15]*C15;
POcp16_13 = RLcp16_13+dpt[1][2];
POcp16_23 = RLcp16_23+dpt[2][2];
JTcp16_13_2 = RLcp16_33*C14;
JTcp16_23_2 = RLcp16_33*S14;
JTcp16_33_2 = -RLcp16_13*C14-RLcp16_23*S14;
OMcp16_13 = OMcp16_12-qd[16]*S14;
OMcp16_23 = OMcp16_22+qd[16]*C14;
ORcp16_13 = OMcp16_22*RLcp16_33;
ORcp16_23 = -OMcp16_12*RLcp16_33;
ORcp16_33 = OMcp16_12*RLcp16_23-OMcp16_22*RLcp16_13;
OPcp16_13 = OPcp16_12-qdd[16]*S14;
OPcp16_23 = OPcp16_22+qdd[16]*C14;
OPcp16_33 = qd[16]*(OMcp16_12*C14+OMcp16_22*S14);
ACcp16_13 = OMcp16_22*ORcp16_33+OPcp16_22*RLcp16_33;
ACcp16_23 = -OMcp16_12*ORcp16_33-OPcp16_12*RLcp16_33;
ACcp16_33 = OMcp16_12*ORcp16_23-OMcp16_22*ORcp16_13+OPcp16_12*RLcp16_23-OPcp16_22*RLcp16_13;
sens->P[1] = POcp16_13;
sens->P[2] = POcp16_23;
sens->P[3] = RLcp16_33;
sens->R[1][1] = ROcp16_116;
sens->R[1][2] = ROcp16_216;
sens->R[1][3] = ROcp16_316;
sens->R[2][1] = -S14;
sens->R[2][2] = C14;
sens->R[3][1] = ROcp16_716;
sens->R[3][2] = ROcp16_816;
sens->R[3][3] = ROcp16_916;
sens->V[1] = ORcp16_13;
sens->V[2] = ORcp16_23;
sens->V[3] = ORcp16_33;
sens->OM[1] = OMcp16_13;
sens->OM[2] = OMcp16_23;
sens->OM[3] = 0;
sens->J[1][14] = -RLcp16_23;
sens->J[1][15] = JTcp16_13_2;
sens->J[2][14] = RLcp16_13;
sens->J[2][15] = JTcp16_23_2;
sens->J[3][15] = JTcp16_33_2;
sens->J[4][15] = -S14;
sens->J[4][16] = -S14;
sens->J[5][15] = C14;
sens->J[5][16] = C14;
sens->J[6][14] = (1.0);
sens->A[1] = ACcp16_13;
sens->A[2] = ACcp16_23;
sens->A[3] = ACcp16_33;
sens->OMP[1] = OPcp16_13;
sens->OMP[2] = OPcp16_23;
sens->OMP[3] = OPcp16_33;

break;

case 17:

ROcp17_115 = C14*C15;
ROcp17_215 = S14*C15;
ROcp17_715 = C14*S15;
ROcp17_815 = S14*S15;
ROcp17_116 = ROcp17_115*C16-ROcp17_715*S16;
ROcp17_216 = ROcp17_215*C16-ROcp17_815*S16;
ROcp17_316 = -C15*S16-S15*C16;
ROcp17_716 = ROcp17_115*S16+ROcp17_715*C16;
ROcp17_816 = ROcp17_215*S16+ROcp17_815*C16;
ROcp17_916 = C15*C16-S15*S16;
ROcp17_417 = ROcp17_716*S17-S14*C17;
ROcp17_517 = ROcp17_816*S17+C14*C17;
ROcp17_617 = ROcp17_916*S17;
ROcp17_717 = ROcp17_716*C17+S14*S17;
ROcp17_817 = ROcp17_816*C17-C14*S17;
ROcp17_917 = ROcp17_916*C17;
OMcp17_12 = -qd[15]*S14;
OMcp17_22 = qd[15]*C14;
OPcp17_12 = -qdd[15]*S14;
OPcp17_22 = qdd[15]*C14;
RLcp17_13 = ROcp17_715*dpt[3][15];
RLcp17_23 = ROcp17_815*dpt[3][15];
RLcp17_33 = dpt[3][15]*C15;
POcp17_13 = RLcp17_13+dpt[1][2];
POcp17_23 = RLcp17_23+dpt[2][2];
JTcp17_13_2 = RLcp17_33*C14;
JTcp17_23_2 = RLcp17_33*S14;
JTcp17_33_2 = -RLcp17_13*C14-RLcp17_23*S14;
OMcp17_13 = OMcp17_12-qd[16]*S14;
OMcp17_23 = OMcp17_22+qd[16]*C14;
ORcp17_13 = OMcp17_22*RLcp17_33;
ORcp17_23 = -OMcp17_12*RLcp17_33;
ORcp17_33 = OMcp17_12*RLcp17_23-OMcp17_22*RLcp17_13;
OPcp17_13 = OPcp17_12-qdd[16]*S14;
OPcp17_23 = OPcp17_22+qdd[16]*C14;
OPcp17_33 = qd[16]*(OMcp17_12*C14+OMcp17_22*S14);
ACcp17_13 = OMcp17_22*ORcp17_33+OPcp17_22*RLcp17_33;
ACcp17_23 = -OMcp17_12*ORcp17_33-OPcp17_12*RLcp17_33;
ACcp17_33 = OMcp17_12*ORcp17_23-OMcp17_22*ORcp17_13+OPcp17_12*RLcp17_23-OPcp17_22*RLcp17_13;
RLcp17_14 = -dpt[2][16]*S14;
RLcp17_24 = dpt[2][16]*C14;
POcp17_14 = POcp17_13+RLcp17_14;
POcp17_24 = POcp17_23+RLcp17_24;
JTcp17_14_1 = -RLcp17_23-RLcp17_24;
JTcp17_24_1 = RLcp17_13+RLcp17_14;
JTcp17_34_2 = JTcp17_33_2-RLcp17_14*C14-RLcp17_24*S14;
JTcp17_34_3 = -RLcp17_14*C14-RLcp17_24*S14;
OMcp17_14 = OMcp17_13+ROcp17_116*qd[17];
OMcp17_24 = OMcp17_23+ROcp17_216*qd[17];
OMcp17_34 = ROcp17_316*qd[17];
ORcp17_34 = OMcp17_13*RLcp17_24-OMcp17_23*RLcp17_14;
VIcp17_34 = ORcp17_33+ORcp17_34;
OPcp17_14 = OPcp17_13+OMcp17_23*ROcp17_316*qd[17]+ROcp17_116*qdd[17];
OPcp17_24 = OPcp17_23-OMcp17_13*ROcp17_316*qd[17]+ROcp17_216*qdd[17];
OPcp17_34 = OPcp17_33+ROcp17_316*qdd[17]+qd[17]*(OMcp17_13*ROcp17_216-OMcp17_23*ROcp17_116);
ACcp17_14 = ACcp17_13+OMcp17_23*ORcp17_34-OPcp17_33*RLcp17_24;
ACcp17_24 = ACcp17_23-OMcp17_13*ORcp17_34+OPcp17_33*RLcp17_14;
ACcp17_34 = ACcp17_33+OPcp17_13*RLcp17_24-OPcp17_23*RLcp17_14;
sens->P[1] = POcp17_14;
sens->P[2] = POcp17_24;
sens->P[3] = RLcp17_33;
sens->R[1][1] = ROcp17_116;
sens->R[1][2] = ROcp17_216;
sens->R[1][3] = ROcp17_316;
sens->R[2][1] = ROcp17_417;
sens->R[2][2] = ROcp17_517;
sens->R[2][3] = ROcp17_617;
sens->R[3][1] = ROcp17_717;
sens->R[3][2] = ROcp17_817;
sens->R[3][3] = ROcp17_917;
sens->V[1] = ORcp17_13;
sens->V[2] = ORcp17_23;
sens->V[3] = VIcp17_34;
sens->OM[1] = OMcp17_14;
sens->OM[2] = OMcp17_24;
sens->OM[3] = OMcp17_34;
sens->J[1][14] = JTcp17_14_1;
sens->J[1][15] = JTcp17_13_2;
sens->J[2][14] = JTcp17_24_1;
sens->J[2][15] = JTcp17_23_2;
sens->J[3][15] = JTcp17_34_2;
sens->J[3][16] = JTcp17_34_3;
sens->J[4][15] = -S14;
sens->J[4][16] = -S14;
sens->J[4][17] = ROcp17_116;
sens->J[5][15] = C14;
sens->J[5][16] = C14;
sens->J[5][17] = ROcp17_216;
sens->J[6][14] = (1.0);
sens->J[6][17] = ROcp17_316;
sens->A[1] = ACcp17_14;
sens->A[2] = ACcp17_24;
sens->A[3] = ACcp17_34;
sens->OMP[1] = OPcp17_14;
sens->OMP[2] = OPcp17_24;
sens->OMP[3] = OPcp17_34;

break;

case 18:

ROcp18_115 = C14*C15;
ROcp18_215 = S14*C15;
ROcp18_715 = C14*S15;
ROcp18_815 = S14*S15;
ROcp18_116 = ROcp18_115*C16-ROcp18_715*S16;
ROcp18_216 = ROcp18_215*C16-ROcp18_815*S16;
ROcp18_316 = -C15*S16-S15*C16;
ROcp18_716 = ROcp18_115*S16+ROcp18_715*C16;
ROcp18_816 = ROcp18_215*S16+ROcp18_815*C16;
ROcp18_916 = C15*C16-S15*S16;
ROcp18_418 = ROcp18_716*S18-S14*C18;
ROcp18_518 = ROcp18_816*S18+C14*C18;
ROcp18_618 = ROcp18_916*S18;
ROcp18_718 = ROcp18_716*C18+S14*S18;
ROcp18_818 = ROcp18_816*C18-C14*S18;
ROcp18_918 = ROcp18_916*C18;
OMcp18_12 = -qd[15]*S14;
OMcp18_22 = qd[15]*C14;
OPcp18_12 = -qdd[15]*S14;
OPcp18_22 = qdd[15]*C14;
RLcp18_13 = ROcp18_715*dpt[3][15];
RLcp18_23 = ROcp18_815*dpt[3][15];
RLcp18_33 = dpt[3][15]*C15;
POcp18_13 = RLcp18_13+dpt[1][2];
POcp18_23 = RLcp18_23+dpt[2][2];
JTcp18_13_2 = RLcp18_33*C14;
JTcp18_23_2 = RLcp18_33*S14;
JTcp18_33_2 = -RLcp18_13*C14-RLcp18_23*S14;
OMcp18_13 = OMcp18_12-qd[16]*S14;
OMcp18_23 = OMcp18_22+qd[16]*C14;
ORcp18_13 = OMcp18_22*RLcp18_33;
ORcp18_23 = -OMcp18_12*RLcp18_33;
ORcp18_33 = OMcp18_12*RLcp18_23-OMcp18_22*RLcp18_13;
OPcp18_13 = OPcp18_12-qdd[16]*S14;
OPcp18_23 = OPcp18_22+qdd[16]*C14;
OPcp18_33 = qd[16]*(OMcp18_12*C14+OMcp18_22*S14);
ACcp18_13 = OMcp18_22*ORcp18_33+OPcp18_22*RLcp18_33;
ACcp18_23 = -OMcp18_12*ORcp18_33-OPcp18_12*RLcp18_33;
ACcp18_33 = OMcp18_12*ORcp18_23-OMcp18_22*ORcp18_13+OPcp18_12*RLcp18_23-OPcp18_22*RLcp18_13;
RLcp18_14 = -dpt[2][17]*S14;
RLcp18_24 = dpt[2][17]*C14;
POcp18_14 = POcp18_13+RLcp18_14;
POcp18_24 = POcp18_23+RLcp18_24;
JTcp18_14_1 = -RLcp18_23-RLcp18_24;
JTcp18_24_1 = RLcp18_13+RLcp18_14;
JTcp18_34_2 = JTcp18_33_2-RLcp18_14*C14-RLcp18_24*S14;
JTcp18_34_3 = -RLcp18_14*C14-RLcp18_24*S14;
OMcp18_14 = OMcp18_13+ROcp18_116*qd[18];
OMcp18_24 = OMcp18_23+ROcp18_216*qd[18];
OMcp18_34 = ROcp18_316*qd[18];
ORcp18_34 = OMcp18_13*RLcp18_24-OMcp18_23*RLcp18_14;
VIcp18_34 = ORcp18_33+ORcp18_34;
OPcp18_14 = OPcp18_13+OMcp18_23*ROcp18_316*qd[18]+ROcp18_116*qdd[18];
OPcp18_24 = OPcp18_23-OMcp18_13*ROcp18_316*qd[18]+ROcp18_216*qdd[18];
OPcp18_34 = OPcp18_33+ROcp18_316*qdd[18]+qd[18]*(OMcp18_13*ROcp18_216-OMcp18_23*ROcp18_116);
ACcp18_14 = ACcp18_13+OMcp18_23*ORcp18_34-OPcp18_33*RLcp18_24;
ACcp18_24 = ACcp18_23-OMcp18_13*ORcp18_34+OPcp18_33*RLcp18_14;
ACcp18_34 = ACcp18_33+OPcp18_13*RLcp18_24-OPcp18_23*RLcp18_14;
sens->P[1] = POcp18_14;
sens->P[2] = POcp18_24;
sens->P[3] = RLcp18_33;
sens->R[1][1] = ROcp18_116;
sens->R[1][2] = ROcp18_216;
sens->R[1][3] = ROcp18_316;
sens->R[2][1] = ROcp18_418;
sens->R[2][2] = ROcp18_518;
sens->R[2][3] = ROcp18_618;
sens->R[3][1] = ROcp18_718;
sens->R[3][2] = ROcp18_818;
sens->R[3][3] = ROcp18_918;
sens->V[1] = ORcp18_13;
sens->V[2] = ORcp18_23;
sens->V[3] = VIcp18_34;
sens->OM[1] = OMcp18_14;
sens->OM[2] = OMcp18_24;
sens->OM[3] = OMcp18_34;
sens->J[1][14] = JTcp18_14_1;
sens->J[1][15] = JTcp18_13_2;
sens->J[2][14] = JTcp18_24_1;
sens->J[2][15] = JTcp18_23_2;
sens->J[3][15] = JTcp18_34_2;
sens->J[3][16] = JTcp18_34_3;
sens->J[4][15] = -S14;
sens->J[4][16] = -S14;
sens->J[4][18] = ROcp18_116;
sens->J[5][15] = C14;
sens->J[5][16] = C14;
sens->J[5][18] = ROcp18_216;
sens->J[6][14] = (1.0);
sens->J[6][18] = ROcp18_316;
sens->A[1] = ACcp18_14;
sens->A[2] = ACcp18_24;
sens->A[3] = ACcp18_34;
sens->OMP[1] = OPcp18_14;
sens->OMP[2] = OPcp18_24;
sens->OMP[3] = OPcp18_34;

break;

case 19:

sens->P[1] = dpt[1][3];
sens->P[2] = dpt[2][3];
sens->P[3] = 0;
sens->R[1][1] = C19;
sens->R[1][2] = S19;
sens->R[2][1] = -S19;
sens->R[2][2] = C19;
sens->R[3][3] = (1.0);
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = 0;
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[6][19] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = 0;
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 20:

ROcp20_120 = C19*C20;
ROcp20_220 = S19*C20;
ROcp20_720 = C19*S20;
ROcp20_820 = S19*S20;
OMcp20_12 = -qd[20]*S19;
OMcp20_22 = qd[20]*C19;
OPcp20_12 = -qdd[20]*S19;
OPcp20_22 = qdd[20]*C19;
sens->P[1] = dpt[1][3];
sens->P[2] = dpt[2][3];
sens->P[3] = 0;
sens->R[1][1] = ROcp20_120;
sens->R[1][2] = ROcp20_220;
sens->R[1][3] = -S20;
sens->R[2][1] = -S19;
sens->R[2][2] = C19;
sens->R[3][1] = ROcp20_720;
sens->R[3][2] = ROcp20_820;
sens->R[3][3] = C20;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = 0;
sens->OM[1] = OMcp20_12;
sens->OM[2] = OMcp20_22;
sens->OM[3] = 0;
sens->J[4][20] = -S19;
sens->J[5][20] = C19;
sens->J[6][19] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = 0;
sens->OMP[1] = OPcp20_12;
sens->OMP[2] = OPcp20_22;
sens->OMP[3] = 0;

break;

case 21:

ROcp21_120 = C19*C20;
ROcp21_220 = S19*C20;
ROcp21_720 = C19*S20;
ROcp21_820 = S19*S20;
ROcp21_121 = ROcp21_120*C21-ROcp21_720*S21;
ROcp21_221 = ROcp21_220*C21-ROcp21_820*S21;
ROcp21_321 = -C20*S21-S20*C21;
ROcp21_721 = ROcp21_120*S21+ROcp21_720*C21;
ROcp21_821 = ROcp21_220*S21+ROcp21_820*C21;
ROcp21_921 = C20*C21-S20*S21;
OMcp21_12 = -qd[20]*S19;
OMcp21_22 = qd[20]*C19;
OPcp21_12 = -qdd[20]*S19;
OPcp21_22 = qdd[20]*C19;
RLcp21_13 = ROcp21_720*dpt[3][19];
RLcp21_23 = ROcp21_820*dpt[3][19];
RLcp21_33 = dpt[3][19]*C20;
POcp21_13 = RLcp21_13+dpt[1][3];
POcp21_23 = RLcp21_23+dpt[2][3];
JTcp21_13_2 = RLcp21_33*C19;
JTcp21_23_2 = RLcp21_33*S19;
JTcp21_33_2 = -RLcp21_13*C19-RLcp21_23*S19;
OMcp21_13 = OMcp21_12-qd[21]*S19;
OMcp21_23 = OMcp21_22+qd[21]*C19;
ORcp21_13 = OMcp21_22*RLcp21_33;
ORcp21_23 = -OMcp21_12*RLcp21_33;
ORcp21_33 = OMcp21_12*RLcp21_23-OMcp21_22*RLcp21_13;
OPcp21_13 = OPcp21_12-qdd[21]*S19;
OPcp21_23 = OPcp21_22+qdd[21]*C19;
OPcp21_33 = qd[21]*(OMcp21_12*C19+OMcp21_22*S19);
ACcp21_13 = OMcp21_22*ORcp21_33+OPcp21_22*RLcp21_33;
ACcp21_23 = -OMcp21_12*ORcp21_33-OPcp21_12*RLcp21_33;
ACcp21_33 = OMcp21_12*ORcp21_23-OMcp21_22*ORcp21_13+OPcp21_12*RLcp21_23-OPcp21_22*RLcp21_13;
sens->P[1] = POcp21_13;
sens->P[2] = POcp21_23;
sens->P[3] = RLcp21_33;
sens->R[1][1] = ROcp21_121;
sens->R[1][2] = ROcp21_221;
sens->R[1][3] = ROcp21_321;
sens->R[2][1] = -S19;
sens->R[2][2] = C19;
sens->R[3][1] = ROcp21_721;
sens->R[3][2] = ROcp21_821;
sens->R[3][3] = ROcp21_921;
sens->V[1] = ORcp21_13;
sens->V[2] = ORcp21_23;
sens->V[3] = ORcp21_33;
sens->OM[1] = OMcp21_13;
sens->OM[2] = OMcp21_23;
sens->OM[3] = 0;
sens->J[1][19] = -RLcp21_23;
sens->J[1][20] = JTcp21_13_2;
sens->J[2][19] = RLcp21_13;
sens->J[2][20] = JTcp21_23_2;
sens->J[3][20] = JTcp21_33_2;
sens->J[4][20] = -S19;
sens->J[4][21] = -S19;
sens->J[5][20] = C19;
sens->J[5][21] = C19;
sens->J[6][19] = (1.0);
sens->A[1] = ACcp21_13;
sens->A[2] = ACcp21_23;
sens->A[3] = ACcp21_33;
sens->OMP[1] = OPcp21_13;
sens->OMP[2] = OPcp21_23;
sens->OMP[3] = OPcp21_33;

break;

case 22:

ROcp22_120 = C19*C20;
ROcp22_220 = S19*C20;
ROcp22_720 = C19*S20;
ROcp22_820 = S19*S20;
ROcp22_121 = ROcp22_120*C21-ROcp22_720*S21;
ROcp22_221 = ROcp22_220*C21-ROcp22_820*S21;
ROcp22_321 = -C20*S21-S20*C21;
ROcp22_721 = ROcp22_120*S21+ROcp22_720*C21;
ROcp22_821 = ROcp22_220*S21+ROcp22_820*C21;
ROcp22_921 = C20*C21-S20*S21;
ROcp22_422 = ROcp22_721*S22-S19*C22;
ROcp22_522 = ROcp22_821*S22+C19*C22;
ROcp22_622 = ROcp22_921*S22;
ROcp22_722 = ROcp22_721*C22+S19*S22;
ROcp22_822 = ROcp22_821*C22-C19*S22;
ROcp22_922 = ROcp22_921*C22;
OMcp22_12 = -qd[20]*S19;
OMcp22_22 = qd[20]*C19;
OPcp22_12 = -qdd[20]*S19;
OPcp22_22 = qdd[20]*C19;
RLcp22_13 = ROcp22_720*dpt[3][19];
RLcp22_23 = ROcp22_820*dpt[3][19];
RLcp22_33 = dpt[3][19]*C20;
POcp22_13 = RLcp22_13+dpt[1][3];
POcp22_23 = RLcp22_23+dpt[2][3];
JTcp22_13_2 = RLcp22_33*C19;
JTcp22_23_2 = RLcp22_33*S19;
JTcp22_33_2 = -RLcp22_13*C19-RLcp22_23*S19;
OMcp22_13 = OMcp22_12-qd[21]*S19;
OMcp22_23 = OMcp22_22+qd[21]*C19;
ORcp22_13 = OMcp22_22*RLcp22_33;
ORcp22_23 = -OMcp22_12*RLcp22_33;
ORcp22_33 = OMcp22_12*RLcp22_23-OMcp22_22*RLcp22_13;
OPcp22_13 = OPcp22_12-qdd[21]*S19;
OPcp22_23 = OPcp22_22+qdd[21]*C19;
OPcp22_33 = qd[21]*(OMcp22_12*C19+OMcp22_22*S19);
ACcp22_13 = OMcp22_22*ORcp22_33+OPcp22_22*RLcp22_33;
ACcp22_23 = -OMcp22_12*ORcp22_33-OPcp22_12*RLcp22_33;
ACcp22_33 = OMcp22_12*ORcp22_23-OMcp22_22*ORcp22_13+OPcp22_12*RLcp22_23-OPcp22_22*RLcp22_13;
RLcp22_14 = -dpt[2][20]*S19;
RLcp22_24 = dpt[2][20]*C19;
POcp22_14 = POcp22_13+RLcp22_14;
POcp22_24 = POcp22_23+RLcp22_24;
JTcp22_14_1 = -RLcp22_23-RLcp22_24;
JTcp22_24_1 = RLcp22_13+RLcp22_14;
JTcp22_34_2 = JTcp22_33_2-RLcp22_14*C19-RLcp22_24*S19;
JTcp22_34_3 = -RLcp22_14*C19-RLcp22_24*S19;
OMcp22_14 = OMcp22_13+ROcp22_121*qd[22];
OMcp22_24 = OMcp22_23+ROcp22_221*qd[22];
OMcp22_34 = ROcp22_321*qd[22];
ORcp22_34 = OMcp22_13*RLcp22_24-OMcp22_23*RLcp22_14;
VIcp22_34 = ORcp22_33+ORcp22_34;
OPcp22_14 = OPcp22_13+OMcp22_23*ROcp22_321*qd[22]+ROcp22_121*qdd[22];
OPcp22_24 = OPcp22_23-OMcp22_13*ROcp22_321*qd[22]+ROcp22_221*qdd[22];
OPcp22_34 = OPcp22_33+ROcp22_321*qdd[22]+qd[22]*(OMcp22_13*ROcp22_221-OMcp22_23*ROcp22_121);
ACcp22_14 = ACcp22_13+OMcp22_23*ORcp22_34-OPcp22_33*RLcp22_24;
ACcp22_24 = ACcp22_23-OMcp22_13*ORcp22_34+OPcp22_33*RLcp22_14;
ACcp22_34 = ACcp22_33+OPcp22_13*RLcp22_24-OPcp22_23*RLcp22_14;
sens->P[1] = POcp22_14;
sens->P[2] = POcp22_24;
sens->P[3] = RLcp22_33;
sens->R[1][1] = ROcp22_121;
sens->R[1][2] = ROcp22_221;
sens->R[1][3] = ROcp22_321;
sens->R[2][1] = ROcp22_422;
sens->R[2][2] = ROcp22_522;
sens->R[2][3] = ROcp22_622;
sens->R[3][1] = ROcp22_722;
sens->R[3][2] = ROcp22_822;
sens->R[3][3] = ROcp22_922;
sens->V[1] = ORcp22_13;
sens->V[2] = ORcp22_23;
sens->V[3] = VIcp22_34;
sens->OM[1] = OMcp22_14;
sens->OM[2] = OMcp22_24;
sens->OM[3] = OMcp22_34;
sens->J[1][19] = JTcp22_14_1;
sens->J[1][20] = JTcp22_13_2;
sens->J[2][19] = JTcp22_24_1;
sens->J[2][20] = JTcp22_23_2;
sens->J[3][20] = JTcp22_34_2;
sens->J[3][21] = JTcp22_34_3;
sens->J[4][20] = -S19;
sens->J[4][21] = -S19;
sens->J[4][22] = ROcp22_121;
sens->J[5][20] = C19;
sens->J[5][21] = C19;
sens->J[5][22] = ROcp22_221;
sens->J[6][19] = (1.0);
sens->J[6][22] = ROcp22_321;
sens->A[1] = ACcp22_14;
sens->A[2] = ACcp22_24;
sens->A[3] = ACcp22_34;
sens->OMP[1] = OPcp22_14;
sens->OMP[2] = OPcp22_24;
sens->OMP[3] = OPcp22_34;

break;

case 23:

ROcp23_120 = C19*C20;
ROcp23_220 = S19*C20;
ROcp23_720 = C19*S20;
ROcp23_820 = S19*S20;
ROcp23_121 = ROcp23_120*C21-ROcp23_720*S21;
ROcp23_221 = ROcp23_220*C21-ROcp23_820*S21;
ROcp23_321 = -C20*S21-S20*C21;
ROcp23_721 = ROcp23_120*S21+ROcp23_720*C21;
ROcp23_821 = ROcp23_220*S21+ROcp23_820*C21;
ROcp23_921 = C20*C21-S20*S21;
ROcp23_423 = ROcp23_721*S23-S19*C23;
ROcp23_523 = ROcp23_821*S23+C19*C23;
ROcp23_623 = ROcp23_921*S23;
ROcp23_723 = ROcp23_721*C23+S19*S23;
ROcp23_823 = ROcp23_821*C23-C19*S23;
ROcp23_923 = ROcp23_921*C23;
OMcp23_12 = -qd[20]*S19;
OMcp23_22 = qd[20]*C19;
OPcp23_12 = -qdd[20]*S19;
OPcp23_22 = qdd[20]*C19;
RLcp23_13 = ROcp23_720*dpt[3][19];
RLcp23_23 = ROcp23_820*dpt[3][19];
RLcp23_33 = dpt[3][19]*C20;
POcp23_13 = RLcp23_13+dpt[1][3];
POcp23_23 = RLcp23_23+dpt[2][3];
JTcp23_13_2 = RLcp23_33*C19;
JTcp23_23_2 = RLcp23_33*S19;
JTcp23_33_2 = -RLcp23_13*C19-RLcp23_23*S19;
OMcp23_13 = OMcp23_12-qd[21]*S19;
OMcp23_23 = OMcp23_22+qd[21]*C19;
ORcp23_13 = OMcp23_22*RLcp23_33;
ORcp23_23 = -OMcp23_12*RLcp23_33;
ORcp23_33 = OMcp23_12*RLcp23_23-OMcp23_22*RLcp23_13;
OPcp23_13 = OPcp23_12-qdd[21]*S19;
OPcp23_23 = OPcp23_22+qdd[21]*C19;
OPcp23_33 = qd[21]*(OMcp23_12*C19+OMcp23_22*S19);
ACcp23_13 = OMcp23_22*ORcp23_33+OPcp23_22*RLcp23_33;
ACcp23_23 = -OMcp23_12*ORcp23_33-OPcp23_12*RLcp23_33;
ACcp23_33 = OMcp23_12*ORcp23_23-OMcp23_22*ORcp23_13+OPcp23_12*RLcp23_23-OPcp23_22*RLcp23_13;
RLcp23_14 = -dpt[2][21]*S19;
RLcp23_24 = dpt[2][21]*C19;
POcp23_14 = POcp23_13+RLcp23_14;
POcp23_24 = POcp23_23+RLcp23_24;
JTcp23_14_1 = -RLcp23_23-RLcp23_24;
JTcp23_24_1 = RLcp23_13+RLcp23_14;
JTcp23_34_2 = JTcp23_33_2-RLcp23_14*C19-RLcp23_24*S19;
JTcp23_34_3 = -RLcp23_14*C19-RLcp23_24*S19;
OMcp23_14 = OMcp23_13+ROcp23_121*qd[23];
OMcp23_24 = OMcp23_23+ROcp23_221*qd[23];
OMcp23_34 = ROcp23_321*qd[23];
ORcp23_34 = OMcp23_13*RLcp23_24-OMcp23_23*RLcp23_14;
VIcp23_34 = ORcp23_33+ORcp23_34;
OPcp23_14 = OPcp23_13+OMcp23_23*ROcp23_321*qd[23]+ROcp23_121*qdd[23];
OPcp23_24 = OPcp23_23-OMcp23_13*ROcp23_321*qd[23]+ROcp23_221*qdd[23];
OPcp23_34 = OPcp23_33+ROcp23_321*qdd[23]+qd[23]*(OMcp23_13*ROcp23_221-OMcp23_23*ROcp23_121);
ACcp23_14 = ACcp23_13+OMcp23_23*ORcp23_34-OPcp23_33*RLcp23_24;
ACcp23_24 = ACcp23_23-OMcp23_13*ORcp23_34+OPcp23_33*RLcp23_14;
ACcp23_34 = ACcp23_33+OPcp23_13*RLcp23_24-OPcp23_23*RLcp23_14;
sens->P[1] = POcp23_14;
sens->P[2] = POcp23_24;
sens->P[3] = RLcp23_33;
sens->R[1][1] = ROcp23_121;
sens->R[1][2] = ROcp23_221;
sens->R[1][3] = ROcp23_321;
sens->R[2][1] = ROcp23_423;
sens->R[2][2] = ROcp23_523;
sens->R[2][3] = ROcp23_623;
sens->R[3][1] = ROcp23_723;
sens->R[3][2] = ROcp23_823;
sens->R[3][3] = ROcp23_923;
sens->V[1] = ORcp23_13;
sens->V[2] = ORcp23_23;
sens->V[3] = VIcp23_34;
sens->OM[1] = OMcp23_14;
sens->OM[2] = OMcp23_24;
sens->OM[3] = OMcp23_34;
sens->J[1][19] = JTcp23_14_1;
sens->J[1][20] = JTcp23_13_2;
sens->J[2][19] = JTcp23_24_1;
sens->J[2][20] = JTcp23_23_2;
sens->J[3][20] = JTcp23_34_2;
sens->J[3][21] = JTcp23_34_3;
sens->J[4][20] = -S19;
sens->J[4][21] = -S19;
sens->J[4][23] = ROcp23_121;
sens->J[5][20] = C19;
sens->J[5][21] = C19;
sens->J[5][23] = ROcp23_221;
sens->J[6][19] = (1.0);
sens->J[6][23] = ROcp23_321;
sens->A[1] = ACcp23_14;
sens->A[2] = ACcp23_24;
sens->A[3] = ACcp23_34;
sens->OMP[1] = OPcp23_14;
sens->OMP[2] = OPcp23_24;
sens->OMP[3] = OPcp23_34;

break;

default:

break;

}


// Number of continuation lines = 0

}
